/*
	pathexpand.c
*/

#include "pathexpand.h"

/*
	pX "drive:" ̒擾B
	݂Ȃꍇ0B
*/
static int pathexpand_get_drive_offset( const char *path )
{
	int i;
	for( i = 0; path[i]; i++ ){
		if( ! isalnum( path[i] ) ) break;
	}
	if( path[i] == ':' ) return i + 1;
	return 0;
}

/*
	΃pX𐳋KB
	/..//./Adir/../dir2/ƌ璷\̂ĂB
	̐A̒邱Ƃ͂Ȃ̂ŁAobt@TCYlȂB
*/
static void pathexpand_normalize_abspath( char *path )
{
	int i, j;
	
	/* hCu΂ */
	path += pathexpand_get_drive_offset( path );
	
	/* "//","///"Ȃǂ̖ʂȃXbV̘Ar */
	for( i = 0, j = 0; path[i + 1]; i++ ){
		if( path[i] == '/' && path[i + 1] == '/' ) continue;
		if( j < i ) path[j] = path[i];
		j++;
	}
	path[j++] = path[i];
	path[j]   = '\0';
	
	/* "." ƂJgfBNgwr */
	for( i = 0, j = 0; path[i + 1]; i++ ){
		if(
			path[i] == '/' &&
			path[i + 1] == '.' &&
			( path[i + 2] == '/' || path[i + 2] == '\0' )
		){
			i += 1;
			continue;
		}
		if( j < i ) path[j] = path[i];
		j++;
	}
	path[j++] = path[i];
	path[j]   = '\0';
	
	/* efBNgw".." */
	for( i = 0, j = 0; path[i]; i++ ){
		if(
			path[i] == '/' &&
			path[i + 1] == '.' &&
			path[i + 2] == '.' &&
			( path[i + 3] == '/' || path[i + 3] == '\0' )
		){
			i += 2;
			if( j ) for( j--; j && path[j] != '/'; j-- );
			continue;
		}
		if( j < i ) path[j] = path[i];
		j++;
	}
	path[j] = '\0';
	
	if( path[j - 1] == '/' ) path[j - 1] = '\0';
}

bool pathexpandFromBase( const char* basepath, const char *path, char *resolved_path, size_t len )
{
	if( ! path || ! resolved_path || ! len ) return false;
	
	/* pathRs[ */
	char *rel_path = (char *)memoryAlloc( strlen( path ) + 1 );
	if( ! rel_path ) return false;
	strcpy( rel_path, path );
	
	if( pathexpand_get_drive_offset( path ) ){
		/* pXhCu܂ޏꍇ͊ɐ΃pXȂ̂ŃRs[ */
		strutilCopy( resolved_path, rel_path, len );
	} else{
		/* hCuꍇ́Abasepath݂̑ɂĕ */
		if( ! basepath ){
			/* basepathꍇ́AJgfBNĝ܂܎gp */
			//getcwd( resolved_path, len );
		} else{
			/* basepathresolved_path̃|C^dȂĂ\lbasepathޔ */
			char *base = (char *)memoryAlloc( strlen( basepath ) + 1 );
			if( ! base ){
				memoryFree( rel_path );
				return false;
			}
			strcpy( base, basepath );
			if( pathexpand_get_drive_offset( base ) ){
				/* basepathhCu܂ޏꍇ́A΃pXȂ̂ŃRs[ */
				strutilCopy( resolved_path, base, len );
			} else{
				/* basepathhCu܂܂Ȃꍇ́A΃pXȂ̂ŃJgfBNg擾 */
				//getcwd( resolved_path, len );
				strutilCat( resolved_path, "/", len );
				strutilCat( resolved_path, base, len );
			}
			memoryFree( base );
		}
		
		if( path[0] == '/' ){
			/* pXXbVn܂Ă΁Ã݂hCũ[gݒ */
			int drive_offset = pathexpand_get_drive_offset( resolved_path );
			resolved_path[drive_offset] = '\0';
		}
		
		strutilCat( resolved_path, "/", len );
		strutilCat( resolved_path, rel_path, len );
	}
	memoryFree( rel_path );
	
	pathexpand_normalize_abspath( resolved_path );
	
	return true;
}

bool pathexpandFromCwd( const char *path, char *resolved_path, size_t len )
{
	return pathexpandFromBase( NULL, path, resolved_path, len );
}
